/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package deadlock;

import tasks.TakeABreak;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class Task1 implements Runnable {

    //This task requires two shared resources
    SharedResource1 res1;
    SharedResource2 res2;
    
    //The constructor will pass in the resources required
    public Task1(SharedResource1 res1,SharedResource2 res2){
        this.res1=res1;
        this.res2=res2;
    }

    public void run() {
        System.out.println(Thread.currentThread().getName()
                           +" is waiting to acquire a Lock on first resource.");
        synchronized (res1) {//get a lock on first resource
            System.out.println(Thread.currentThread().getName()
                           +" acquired lock on first resource.");
            TakeABreak.sleep();
            System.out.println(Thread.currentThread().getName()
                               +" is waiting to acquire a Lock on second resource.");
            synchronized (res2) {//get a lock on second resource
                System.out.println(Thread.currentThread().getName()
                           +" acquired lock on second resource.");
            }
            System.out.println(Thread.currentThread().getName()
                               +" released lock on second resource.");
        }
        System.out.println(Thread.currentThread().getName()
                           +" released lock on first resource.");
    }
}
